% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_summary.R
\name{complete_summary}
\alias{complete_summary}
\title{Summary}
\usage{
complete_summary(full_bayesian_fit)
}
\arguments{
\item{full_bayesian_fit}{The return value of a call to function \code{estimate_BIN}.}
}
\value{
List containing the parameter estimates of the model, the posterior inferences, and the analysis
of predictive performance.

The elements of the list are as follows.
\itemize{
\item Parameter Estimates: Posterior means, standard deviations, and different quantiles of the model parameters and their differences.
The parameter values represent the following quantities.
\itemize{
\item mu_star: Base rate of the event outcome in the probit scale. E.g., if mu_star = 0, then, in expectation, Phi(0)*100\% = 50\% of the events happen, where Phi(.) is the CDF of a standard Gaussian random variable.
\item mu_0: The level of bias in the control group. This can be any number in the real-line. E.g., if mu_0 = 0.1, then the control group believes the base rate to be Phi(mu_star + 0.1).
\item mu_1: The level of bias in the treatment group; otherwise the interpretation is the same as above for mu_0.
\item gamma_0: The level of information in the control group. This is a number between 0 and 1, where 0 represents no information and 1 represents full information.
\item gamma_1: The level of information in the treatment group; otherwise the interpretation is the same as above for gamma_0.
\item delta_0: The level of noise in the control group. This is a positive value, with higher values indicating higher levels of noise. Noise is in the same scale as information. E.g., delta_0 = 1.0 says that the control group uses as many irrelevant signals as there are relevant signals in the universe. In this sense it represents a very high level of noise.
\item delta_1: The level of noise in the treatment group; otherwise the interpretation is the same as above for delta_0.
\item rho_0: The level of within-group dependence between forecasts of the control group. This is a positive value, with higher values indicating higher levels of dependence. The dependence can be interpreted to stem from shared irrelevant (noise) and/or relevant (information) signals.
\item rho_1: The level of within-group dependence between forecasts of the treatment group; otherwise the interpretation is the same as above for rho_0.
\item rho_01: The level of inter-group dependence between forecasts of the control and treatment groups; otherwise the interpretation is the same as above for rho_0.
}
\item Posterior Inferences: Posterior probabilities of events.
Compared to the control group, does the treatment group have: (i) less bias, (ii) more information, and (iii) less noise?
Intuitively, one can think of these probabilities as the Bayesian analogs of the p-values in classical hypothesis testing – the closer the probability is to 1, the stronger the evidence for the hypothesis.

\item Control,Treatment: This compares the control group against the treatment group.
The value of the contribution gives
\itemize{
\item the mean Brier score of the control group;
\item the mean Brier score of the treatment group;
\item how the difference can be explained in terms of bias, noise, or information; and
\item in percentage terms, how does the change in bias, noise, or information (from control to treatment group) changes the Brier score.
}
\item Control,Perfect Accuracy: This compares the control group against a treatment group with perfect accuracy;
otherwise the interpretation is the same as above for 'Control,Treatment.'
}
}
\description{
This function uses the return value of a call to the function \code{estimate_BIN} and produces a full BIN analysis based on that object.
}
\examples{
\donttest{
## An example with one group
# a) Simulate synthetic data:
synthetic_data = simulate_data(list(mu_star = -0.8,mu_0 = -0.5,mu_1 = 0.2,gamma_0 = 0.1,
gamma_1 = 0.3,rho_0 = 0.05,delta_0 = 0.1,rho_1 = 0.2, delta_1 = 0.3,rho_01 = 0.05),300,100,0)
# b) Estimate the BIN-model on the synthetic data:
full_bayesian_fit = estimate_BIN(synthetic_data$Outcomes,synthetic_data$Control, warmup = 500,
iter = 1000)
# c) Analyze the results:
complete_summary(full_bayesian_fit)
}
\donttest{
## An example with two groups
# a) Simulate synthetic data:
synthetic_data = simulate_data(list(mu_star = -0.8,mu_0 = -0.5,mu_1 = 0.2,gamma_0 = 0.1,
gamma_1 = 0.3, rho_0 = 0.05,delta_0 = 0.1, rho_1 = 0.2, delta_1 = 0.3,rho_01 = 0.05), 300,100,100)
# b) Estimate the BIN-model on the synthetic data:
full_bayesian_fit = estimate_BIN(synthetic_data$Outcomes,synthetic_data$Control,
synthetic_data$Treatment, warmup = 500, iter = 1000)
# c) Analyze the results:
complete_summary(full_bayesian_fit)
}

}
\seealso{
\code{\link{simulate_data}}, \code{\link{estimate_BIN}}
}
