\name{BNSP-package}

\alias{BNSP-package}
\alias{BNSP}

\docType{package}

\title{Bayesian non- and semi-parametric model fitting}

\description{Markov chain Monte Carlo algorithms for non- and semi-parametric models: 1. spike-slab variable selection in multivariate mean/variance regression models with function \code{mvrm}, 2. joint mean-covariance models for multivariate longitudinal responses with function \code{lmrm}, and 3. Dirichlet process mixture models with function \code{dpmj}.}

\details{
\tabular{ll}{
Package: \tab BNSP\cr
Type: \tab Package\cr
Version: \tab 2.2.3\cr
Date: \tab 2023-05-25\cr
License: \tab GPL (>=2)\cr}

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

For details on  the GNU General Public License
see \url{http://www.gnu.org/copyleft/gpl.html} or
write to the Free Software Foundation, Inc., 51 Franklin Street,
Fifth Floor, Boston, MA  02110-1301, USA.}

\author{
Georgios Papageorgiou (2014)

Maintainer: Georgios Papageorgiou <gpapageo@gmail.com>}

\references{
Papageorgiou, G. (2020). Bayesian semiparametric modelling of covariance matrices for multivariate longitudinal data. https://arxiv.org/abs/2012.09833 

Papageorgiou, G. and Marshall, B.C. (2020). Bayesian semiparametric analysis of multivariate continuous responses, with variable selection. Journal of Computational and Graphical Statistics, 29:4, 896-909, DOI: 10.1080/10618600.2020.1739534

Papageorgiou, G. (2018). BNSP: an R Package for fitting Bayesian semiparametric regression models and variable selection. The R Journal, 10(2):526-548.

Papageorgiou, G. (2018). Bayesian density regression for discrete outcomes. Australian and New Zealand Journal of Statistics, arXiv:1603.09706v3 [stat.ME]. 

Papageorgiou, G., Richardson, S. and Best, N. (2015). Bayesian nonparametric models for spatially indexed data of mixed type.
Journal of the Royal Statistical Society: Series B (Statistical Methodology), 77:973-999.
}
