% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Framingh}
\alias{Framingh}
\title{Cholesterol values of 62 subjects in the Framingham Heart Study}
\format{
A data frame/tibble with 62 observations on one variable
\describe{ 
\item{cholest}{a numeric vector with cholesterol values} 
}
}
\source{
R. D'Agostino, et al., (1990) "A Suggestion for Using Powerful and Informative
Tests for Normality," \emph{The American Statistician, 44} 316-321.
}
\usage{
Framingh
}
\description{
Data for Exercises 1.56, 1.75, 3.69, and 5.60
}
\examples{

stem(Framingh$cholest)
boxplot(Framingh$cholest, horizontal = TRUE)
hist(Framingh$cholest, freq = FALSE)
lines(density(Framingh$cholest))
mean(Framingh$cholest > 200 & Framingh$cholest < 240)

\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Framingh, aes(x = factor(1), y = cholest)) + 
  geom_boxplot() +                 # boxplot
  labs(x = "") +                   # no x label  
  theme_bw() +                     # black and white theme  
  geom_jitter(width = 0.2) +       # jitter points
  coord_flip()                     # Create horizontal plot
ggplot2::ggplot(data = Framingh, aes(x = cholest, y = ..density..)) +
  geom_histogram(fill = "pink", binwidth = 15, color = "black") + 
  geom_density() + 
  theme_bw()
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
