% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_diagnostics.R
\name{computeLogLik}
\alias{computeLogLik}
\title{Compute log-likelihood}
\usage{
computeLogLik(out, verbose = FALSE, addthin = 1)
}
\arguments{
\item{out}{Output from BSTFA or BSTFAfull.}

\item{verbose}{Logical scalar indicating whether to print status of the log-likelihood computation.  Default is \code{FALSE}.}

\item{addthin}{Numeric scalar indicating the number of additional draws to thin by to reduce the computation time.  Default is \code{1} (no additional thinning).}
}
\value{
A matrix of size \code{n.times*n.locs} by \code{draws} log-likelihood values for each observation and each posterior draw.
}
\description{
Compute log-likelihood
}
\examples{
data(out.sm)
attach(out.sm)
loglik <- computeLogLik(out.sm, addthin=2)
}
\author{
Adam Simpson and Candace Berrett
}
