% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bdvmf}
\alias{bdvmf}
\title{Simulated von Mises-Fisher Data}
\format{
\itemize{
\code{bdvmf$x}: A \eqn{300 \times 3} numeric matrix containing simulated von Mises-Fisher data. 

\code{bdvmf$group}: A group index vector.
}
}
\description{
Simulated random vectors following the von Mises-Fisher distribution 
with mean direction \eqn{\mu_{x}=(1, 0, 0)} and \eqn{\mu_{y}=(1, 1, 1)}, 
and concentration parameter is \eqn{\kappa = 3}.
}
\details{
In directional statistics, the von Mises–Fisher distribution 
(named after Ronald Fisher and Richard von Mises), is a probability distribution
on the \eqn{(p-1)}-dimensional sphere in \eqn{R^{p}}

The parameters \eqn{\mu}, and \eqn{\kappa}, are called the mean direction and concentration
parameter, respectively. The greater the value of \eqn{\kappa}, 
the higher the concentration of the distribution around the mean 
direction \eqn{\mu},. The distribution is unimodal for \eqn{\kappa}, 
and is uniform on the sphere for \eqn{\kappa=0}.
}
\references{
Embleton, N. I. Fisher, T. Lewis, B. J. J. (1993). Statistical analysis of spherical data (1st pbk. ed.). Cambridge: Cambridge University Press. pp. 115–116. ISBN 0-521-45699-1.
}
