% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.data.R
\name{generate.data}
\alias{generate.data}
\title{Generate Data for A Basket Trial Design}
\usage{
generate.data(N, ORRs, ntrial = 10000, seed = 987897)
}
\arguments{
\item{N}{a matrix with \code{dim=c(B, stage)}, where \code{B} is the number of baskets and
\code{stage} is the # of analyses (interim+final)}

\item{ORRs}{a matrix with \code{dim=c(nS, B)}, where \code{nS} is the number of trial scenarios for objective
response rates.}

\item{ntrial}{the total number of trials simulated.}

\item{seed}{random seed for reproducibility.}
}
\value{
It returns a list including \code{data}, \code{N}, and \code{ORRs}, where \code{data} is an
array with \code{dim=c(nS, ntrial, B, stage)}.
}
\description{
Generate Data for A Basket Trial Design
}
\examples{
N <- rbind(
c(10, 25),
c(10, 25),
c(10, 25)) # interim sample size and total sample size for each indication
scenarios <- rbind( c(0.15, 0.15, 0.15), c(0.3, 0.3, 0.3) )
res <- generate.data(N = N, ORRs = scenarios, ntrial = 20, seed = 2024)
}
