% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qn0_mk.R
\name{qn0_mk}
\alias{qn0_mk}
\title{Mixing probability for creating new cluster per bin}
\usage{
qn0_mk(w, m0, bs, as, M, km, lambda, mk, Yn, kstar)
}
\arguments{
\item{w}{A scalar representing the minimum number of points in each interval between two change points}

\item{m0}{A scalar for the number of positions available to define change-points positions}

\item{bs}{The hyperparameter value for the scale parameter in the inverse-gamma prior for the variance
component}

\item{as}{The hyperparameter value for the shape parameter in the inverse-gamma prior for the variance
component}

\item{M}{A scalar representing the number of points available for each data sequence}

\item{km}{A scalar for the number of changes points in a cluster}

\item{lambda}{A scalar defining the parameter for the Truncate Poisson distribution
that controls the number of change points (or its initial values)}

\item{mk}{A matrix with all possible values to distribute between change points}

\item{Yn}{A vector with a data sequence}

\item{kstar}{A scalar with the number maximum of change points in all clusters}
}
\value{
A numerical value representing the mixing value term used to compute the probability that the given data sequence should be a singleton cluster for a given bin size.
}
\description{
Mixing probability for creating new cluster per bin
}
\note{
This function is called within [qn0()]. It should not be called alone.
}
\examples{
data(data)
M <- 50; k <- 0; w <- 10;
m0 <- M - 1 -(k+1)*w
for(k in 0:2){
mk <- RcppAlgos::permuteGeneral(0:m0, k + 1,
constraintFun = "sum",
comparisonFun = "==", limitConstraints = m0,
repetition = TRUE)}
out <- qn0_mk(w = 10, m0 = m0, bs = 1000, as = 2, M = 50, km = 1,
 lambda = 2, mk = mk[1,], Yn = data[,1], kstar = 2)
}
\seealso{
[qn0()], [gibbs_alg()]
}
