% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{detect_cp_epi}
\alias{detect_cp_epi}
\title{Detect Change Points on a epidemic diffusion}
\usage{
detect_cp_epi(
  data,
  n_iterations,
  q,
  M,
  xi,
  a0,
  b0,
  I0_var = 0.01,
  print_progress = TRUE,
  user_seed = 1234L
)
}
\arguments{
\item{data}{a matrix where each column is a component of the epidemic diffusion and the rows correspond to the times.}

\item{n_iterations}{number of MCMC iterations.}

\item{q}{probability of performing a split at each iteration.}

\item{M}{number of Monte Carlo iterations when computing the likelihood of the epidemic diffusion.}

\item{xi}{recovery rate fixed constant for each population at each time.}

\item{a0, b0}{parameters for the computation of the integrated likelihood of the epidemic_diffusions.}

\item{I0_var}{variance for the Metropolis-Hastings estimation of the proportion of infected at time 0.}

\item{print_progress}{If TRUE (default) print the progress bar.}

\item{user_seed}{seed for random distribution generation.}
}
\value{
Function \code{detect_cp_epi} returns a list containing the following components: \itemize{
\item{\code{$orders}} a matrix where each row corresponds to the output order of the corresponding iteration.
\item{\code{time}} computational time in seconds.
\item{\code{$I0_MCMC}} traceplot for \eqn{I_0}.
}
}
\description{
Detect Change Points on a epidemic diffusion
}
\keyword{internal}
