% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{detect_cp_multi}
\alias{detect_cp_multi}
\title{Detect Change Points on multivariate time series}
\usage{
detect_cp_multi(
  data,
  n_iterations,
  q,
  k_0,
  nu_0,
  S_0,
  m_0,
  prior_delta_c = 1,
  prior_delta_d = 1,
  prior_var_phi = 0.1,
  print_progress = TRUE,
  user_seed = 1234L
)
}
\arguments{
\item{data}{a matrix where each row is a component of the time series and the columns correpospond to the times.}

\item{n_iterations}{number of MCMC iterations.}

\item{q}{probability of performing a split at each iteration.}

\item{k_0, nu_0, S_0, m_0}{parameters for the Normal-Inverse-Wishart prior for \eqn{(\mu,\lambda)}.}

\item{prior_delta_c, prior_delta_d}{parameters for the shifted Gamma prior for \eqn{\delta}.}

\item{prior_var_phi}{parameters for the correlation coefficient in the likelihood.}

\item{print_progress}{If TRUE (default) print the progress bar.}

\item{user_seed}{seed for random distribution generation.}
}
\value{
Function \code{detect_cp_multi} returns a list containing the following components: \itemize{
\item{\code{$orders}} a matrix where each row corresponds to the output order of the corresponding iteration.
\item{\code{time}} computational time in seconds.
\item{\code{$phi_MCMC}} traceplot for \eqn{\gamma}.
\item{\code{$sigma_MCMC}} traceplot for \eqn{\sigma}.
\item{\code{$delta_MCMC}} traceplot for \eqn{\delta}.
}
}
\description{
Detect Change Points on multivariate time series
}
\keyword{internal}
