% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgwqs.fit.R
\name{bgwqs.fit}
\alias{bgwqs.fit}
\title{Bayesian Grouped WQS Regression}
\usage{
bgwqs.fit(
  y,
  x,
  z,
  x.s,
  n.quantiles = 4,
  working.dir,
  n.chains = 1,
  n.iter = 10000,
  n.burnin = 5000,
  n.thin = 1,
  n.adapt = 500,
  DIC = FALSE
)
}
\arguments{
\item{y}{A vector containing outcomes.}

\item{x}{A matrix of component data.}

\item{z}{A vector or matrix of controlling covariates.}

\item{x.s}{A vector of the number of components in each index.}

\item{n.quantiles}{The number of quantiles to apply to the component data.}

\item{working.dir}{A file path to the directory.}

\item{n.chains}{The number of Markov chains; must be a positive integer.}

\item{n.iter}{The number of total iterations per chain, including burn in.}

\item{n.burnin}{The number of iterations to discard at the beginning.}

\item{n.thin}{The thinning rate; must be a positive integer.}

\item{n.adapt}{The number of adaption iterations.}

\item{DIC}{Logical; whether or not the user desires the function to return DIC.}
}
\value{
A list which includes BUGS output, sample chains post-burnin, and convergence test results.
}
\description{
This function fits a Bayesian grouped weighted quantile sum (BGWQS) regression model.
}
\examples{
\dontrun{
data("simdata")
group_list <- list(c("pcb_118", "pcb_138", "pcb_153", "pcb_180", "pcb_192"),
                   c("as", "cu", "pb", "sn"),
                   c("carbaryl", "propoxur", "methoxychlor", "diazinon", "chlorpyrifos"))
x.s <- make.x.s(simdata, 3, group_list)
X <- make.X(simdata, 3, group_list)
Y <- simdata$Y
work_dir <- tempdir()
results <- bgwqs.fit(y = Y, x = X, x.s = x.s, n.quantiles=4,
                     working.dir = work_dir,
                     n.chains = 1, n.iter = 10000, n.burnin = 5000, n.thin = 1, n.adapt = 500)

}

}
