% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{Calc_VBGF_LAA}
\alias{Calc_VBGF_LAA}
\title{Calc_VBGF_LAA}
\usage{
Calc_VBGF_LAA(Linf, k, L0, Age)
}
\arguments{
\item{Linf}{A single value of asymptotic length for the von Bertalanffy model}

\item{k}{A single value of the growth completion parameter for the von Bertalanffy model}

\item{L0}{A single value of length-at-birth for the von Bertalanffy model}

\item{Age}{A single value or vector of ages to convert to length based on the von Bertalanffy model}
}
\value{
A vector of length-at-ages
}
\description{
Calc_VBGF_LAA
}
\examples{
# Calculate length-at-age for a von Bertalanffy growth curve with given parameters
# and age range
Age_Range <-  0:16
Calc_VBGF_LAA(Linf = 1630, k = 0.15, L0 = 71, Age = Age_Range)
}
