% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes.mfsurv.R
\name{mfsurv.stats}
\alias{mfsurv.stats}
\title{mfsurv.stats}
\usage{
mfsurv.stats(object)
}
\arguments{
\item{object}{an object of class \code{mfsurv}, the output of \code{mfsurv()}.}
}
\value{
list.
}
\description{
A function to calculate the deviance information criterion (DIC) for fitted model objects of class \code{mfsurv}
for which a log-likelihood can be obtained, according to the formula \emph{DIC = -2 * (L - P)},
where \emph{L} is the log likelihood of the data given the posterior means of the parameter and
\emph{P} is the  estimate of the effective number of parameters in the model.
}
\examples{
set.seed(95)
bgl <- Buhaugetal_2009_JCR
bgl <- subset(bgl, coupx == 0)
bgl <- na.omit(bgl)
Y   <- bgl$Y
X   <- as.matrix(cbind(1, bgl[,1:7]))
C   <- bgl$C
Z1  <- matrix(1, nrow = nrow(bgl))
Y0  <- bgl$Y0
model1 <- mfsurv(Y ~ X | C ~ Z1, Y0 = Y0,
                N = 50,
                burn = 20,
                thin = 15,
                w = c(0.1, .1, .1),
                m = 5,
                form = "Weibull",
                na.action = 'na.omit')

mfsurv.stats(model1)
}
