% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpdateRPlee11.R
\name{UpdateRPlee11}
\alias{UpdateRPlee11}
\title{Update coefficients of Bayesian Cox Models}
\usage{
UpdateRPlee11(sobj, hyperpar, ini, S, method, MRF_G, cpp = FALSE)
}
\arguments{
\item{sobj}{a list containing observed data from \code{n} subjects;
\code{t}, \code{di}, \code{X}. See details for more information}

\item{hyperpar}{a list containing prior parameter values}

\item{ini}{a list containing prior parameters' initial values}

\item{S}{the number of subgroups}

\item{method}{a method option from
\code{c("Pooled", "CoxBVSSL", "Sub-struct")}}

\item{MRF_G}{logical value. \code{MRF_G = TRUE} is to fix the MRF graph which
is provided in the argument \code{hyperpar}, and \code{MRF_G = FALSE} is to
use graphical model for learning the MRF graph}

\item{cpp}{logical, whether to use C++ code for faster computation}
}
\value{
A list object with component 'beta.ini' for the updated coefficients
and component 'acceptlee' for the MCMC acceptance rate
}
\description{
This an internal function to update coefficients of the Bayesian Cox Lasso Model
}
