% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{posterior_weighted}
\alias{posterior_weighted}
\title{Weighted-average posterior (convex combination)}
\usage{
posterior_weighted(P, LT, lambda = 0.7)
}
\arguments{
\item{P}{Prior matrix (\eqn{T \times K}); filas no negativas.}

\item{LT}{Likelihood matrix (\eqn{T \times K}); filas no negativas.}

\item{lambda}{Mixing weight in \eqn{[0,1]} (default \code{0.7}).}
}
\value{
Posterior matrix \eqn{W} (\eqn{T \times K}), filas suman 1.
}
\description{
Computes \eqn{W = \lambda P + (1-\lambda)\,LT} row-wise and renormalizes each
row to the unit simplex (suma 1). Expects matrices no negativas con las mismas
dimensiones \eqn{T \times K}.
}
\examples{
T <- 5; K <- 3
P  <- matrix(runif(T*K), T); P  <- P / rowSums(P)
LT <- matrix(runif(T*K), T); LT <- LT / rowSums(LT)
W <- posterior_weighted(P, LT, 0.6)
stopifnot(all(abs(rowSums(W)-1) < 1e-12))

}
\seealso{
\code{\link{posterior_multiplicative}}, \code{\link{posterior_dirichlet}},
  \code{\link{posterior_adaptive}}
}
