% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCalibratedSAM.R
\name{runCalibratedSAM}
\alias{runCalibratedSAM}
\title{Run a Calibrated Simulation Using SAM Priors}
\usage{
runCalibratedSAM(
  nsim = 1000,
  pch,
  delta_threshold,
  nche.c,
  nc.calib,
  nt.calib,
  pc.calib,
  xt.cal = NULL,
  xc.cal = NULL,
  typeIER.cal = 0.1,
  nche,
  nc,
  nt,
  pc,
  pt,
  xt = NULL,
  xc = NULL,
  nf.prior = RBesT::mixbeta(c(1, 0.001, 0.001)),
  seed.hist = 1000,
  seed.gMAP = 2000,
  seed.SAM = 3000,
  seed.cal = 4000
)
}
\arguments{
\item{nsim}{The total number of simulation trials to run for both the
calibration and main simulation steps.}

\item{pch}{Historical control response rate (used to generate \code{HistData}
for the \code{\link[RBesT:gMAP]{RBesT::gMAP()}} prior).}

\item{delta_threshold}{The CSD (Clinically Significant Difference) threshold
used for the SAM prior in \code{\link[=runSAM]{runSAM()}}.}

\item{nche.c}{Sample size for the historical control data (\code{HistData}).}

\item{nc.calib}{Control group sample size for the \strong{calibration} step.}

\item{nt.calib}{Treatment group sample size for the \strong{calibration} step.}

\item{pc.calib}{Control response rate for the \strong{calibration} step. This is
also used as the treatment response rate in this step to simulate the null hypothesis.}

\item{xt.cal}{(Optional) A vector of pre-simulated treatment outcomes for the
\strong{calibration} step. If \code{NULL}, data is simulated internally.}

\item{xc.cal}{(Optional) A vector of pre-simulated control outcomes for the
\strong{calibration} step. If \code{NULL}, data is simulated internally.}

\item{typeIER.cal}{The target Type I Error rate to control for during the
calibration step. Defaults to 0.1.}

\item{nche}{Historical control sample size. (Note: This parameter is defined
in the function signature but not explicitly used in the function body;
\code{nche.c} is used for calibration data generation.)}

\item{nc}{Control group sample size for the \strong{main simulation} step.}

\item{nt}{Treatment group sample size for the \strong{main simulation} step.}

\item{pc}{Control response rate for the \strong{main simulation} step.}

\item{pt}{Treatment response rate for the \strong{main simulation} step. (Note:
Set \code{pt = pc} for Type I Error, or \code{pt > pc} for Power).}

\item{xt}{(Optional) A vector of pre-simulated treatment outcomes for the
\strong{main simulation}. If \code{NULL}, data is simulated internally.}

\item{xc}{(Optional) A vector of pre-simulated control outcomes for the
\strong{main simulation}. Examples use \code{\link[RBesT:mixbeta]{RBesT::mixbeta()}}. If \code{NULL}, data is simulated internally.}

\item{nf.prior}{The non-informative prior to use. Defaults to
\code{RBesT::mixbeta(c(1, 0.001, 0.001))}.}

\item{seed.hist}{Seed for generating historical data.}

\item{seed.gMAP}{Seed for the \code{\link[RBesT:gMAP]{RBesT::gMAP()}} function.}

\item{seed.SAM}{Seed for the main \code{runSAM} simulation call.}

\item{seed.cal}{Seed for the calibration \code{runSAM} call.}
}
\value{
A list with the following components:
\describe{
\item{Sim_Result}{A numeric vector (length 3) with the final simulation
result (Type I Error or Power) for the "SAMprior", "MAP", and
"Noninfo" methods.}
\item{pc.PMD}{Posterior Mean Difference (Bias) for the three methods.}
\item{pc.PSDD}{Posterior SD of the Difference (Bias) for the three methods.}
\item{pc.PM}{A matrix (\verb{3 x nsim}) of posterior means for the control
rate for each simulation iteration.}
\item{Calibration_Thresholds}{A matrix (1x3) containing the
decision thresholds (quantiles) determined during the calibration step
for the SAM, rMAP, and Non-info methods.}
}
}
\description{
Performs a two-step simulation.
\enumerate{
\item \strong{Calibration Step:} It first runs a simulation under the null hypothesis
(using \verb{*.calib} parameters) to determine the posterior probability
thresholds (quantiles) needed to control the Type I Error Rate at the
specified \code{typeIER.cal} level.
\item \strong{Main Simulation Step:} It then uses these calibrated thresholds to run
the main simulation (using parameters \code{nc}, \code{nt}, \code{pc}, \code{pt}) to evaluate
final operating characteristics (e.g., Type I Error or Power) and bias.
}
}
\details{
This function wraps the core \code{\link[=runSAM]{runSAM()}} function by adding a calibration layer.
It derives historical data priors using \code{\link[RBesT:gMAP]{RBesT::gMAP()}} and \code{\link[RBesT:automixfit]{RBesT::automixfit()}}
based on \code{nche.c} and \code{pch}.

The calibration step (\code{runSAM} with \code{...calib} parameters) finds the
\code{(1 - typeIER.cal)} quantiles for the posterior distributions (SAM, rMAP, Non-info)
under the null.

The main simulation step (\code{runSAM} with main parameters) then calculates the
proportion of simulations where the posterior probability exceeds these
calibrated thresholds. This proportion represents the final Type I Error or Power.
}
\examples{
\donttest{
# Example uses functions from the RBesT package
library(RBesT)

sim_power_pc30 <- runCalibratedSAM(
   nsim = 100,
   pch = 0.30,
   delta_threshold = 0.1,
   nche.c = 180,
   nc.calib = 45,
   nt.calib = 45,
   pc.calib = 0.3,
   typeIER.cal = 0.10,
   nche = 180,
   nc = 45,
   nt = 45,
   pc = 0.30,
   pt = 0.50
)

print(sim_power_pc30$Sim_Result)
}

}
\seealso{
\code{\link{runSAM}}, \code{\link[RBesT]{gMAP}},
\code{\link[RBesT]{automixfit}}, \code{\link[RBesT]{mixbeta}},
\code{\link[RBesT]{decision2S}}
}
