% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bernoulli.R
\name{bi.dist.bernoulli}
\alias{bi.dist.bernoulli}
\title{Sample from a Bernoulli distribution.}
\usage{
bi.dist.bernoulli(
  probs = py_none(),
  logits = py_none(),
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{probs}{A numeric vector, matrix, or array representing the probability of success for each Bernoulli trial. Must be between 0 and 1.}

\item{logits}{A numeric vector, matrix, or array representing the log-odds of success for each Bernoulli trial.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{A logical vector, matrix, or array (optional) to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector specifying the shape of the output.  Used with `.expand(shape)` when `sample=False` (model building) to set the distribution's batch shape. When `sample=True` (direct sampling), this is used as `sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{An integer indicating the number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{A logical value (optional). If `TRUE`, returns the raw BI distribution object instead of creating a sample site.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Bernoulli distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Bernoulli distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
The Bernoulli distribution models a single binary event (success or failure),
 parameterized by the log-odds ratio of success.  The probability of success
 is given by the sigmoid function applied to the logit.

 \deqn{
   p = \sigma(\eta) = \frac{1}{1 + e^{-\eta}}
 }

 where \deqn{\eta} is the log-odds (the *logit*).
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.bernoulli(probs = 0.5, sample = TRUE)
bi.dist.bernoulli(probs = 0.5, sample = TRUE, seed = 5)
bi.dist.bernoulli(logits = 1, sample = TRUE, seed = 5)
}
}
