% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTimeSeries.R
\name{plotTimeSeriesResults}
\alias{plotTimeSeriesResults}
\title{Creates a time series plot typical for an MCMC / SMC fit}
\usage{
plotTimeSeriesResults(
  sampler,
  model,
  observed,
  error = NULL,
  plotResiduals = TRUE,
  start = 1,
  prior = FALSE,
  ...
)
}
\arguments{
\item{sampler}{Either a) a matrix b) an MCMC object (list or not), or c) an SMC object}

\item{model}{function that calculates model predictions for a given parameter vector}

\item{observed}{observed values as vector}

\item{error}{function with signature f(mean, par) that generates observations with error (error = stochasticity according to what is assumed in the likelihood) from mean model predictions. Par is a vector from the matrix with the parameter samples (full length). f needs to know which of these parameters are parameters of the error function. See example in \code{\link{VSEM}}}

\item{plotResiduals}{logical determining whether residuals should be plotted}

\item{start}{numeric start value for the plot (see \code{\link{getSample}})}

\item{prior}{if a prior sampler is implemented, setting this parameter to TRUE will draw model parameters from the prior instead of the posterior distribution}

\item{...}{further arguments passed to \code{\link[graphics]{plot}}}
}
\description{
Creates a time series plot typical for an MCMC / SMC fit
}
\examples{
# Create time series
ts <- VSEMcreatePAR(1:100)

# create fake "predictions"
pred <- ts + rnorm(length(ts), mean = 0, sd = 2)

# plot time series
par(mfrow=c(1,2))

plotTimeSeries(observed = ts, main="Observed")
plotTimeSeries(observed = ts, predicted = pred, main = "Observed and predicted")

par(mfrow=c(1,1))

}
\seealso{
\code{\link{getPredictiveIntervals}}
}
\author{
Florian Hartig
}
