/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.speciation;

import dr.evolution.util.Units;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesNetworkModel;
import dr.inference.model.Likelihood;

public class AlloppMSCoalescent
extends Likelihood.Abstract
implements Units {
    private final AlloppSpeciesNetworkModel asnetwork;
    private final AlloppSpeciesBindings apsp;

    public AlloppMSCoalescent(AlloppSpeciesBindings alloppSpeciesBindings, AlloppSpeciesNetworkModel alloppSpeciesNetworkModel) {
        super(alloppSpeciesNetworkModel);
        this.apsp = alloppSpeciesBindings;
        this.asnetwork = alloppSpeciesNetworkModel;
        this.asnetwork.addModelListener(this);
        this.apsp.addModelListeners(this);
    }

    @Override
    protected double calculateLogLikelihood() {
        for (int i = 0; i < this.apsp.numberOfGeneTrees(); ++i) {
            if (this.apsp.geneTreeFitsInNetwork(i, this.asnetwork)) continue;
            return Double.NEGATIVE_INFINITY;
        }
        double d = 0.0;
        for (int i = 0; i < this.apsp.numberOfGeneTrees(); ++i) {
            double d2 = this.apsp.geneTreeLogLikelihood(i, this.asnetwork);
            assert (!Double.isNaN(d2));
            d += d2;
        }
        return d;
    }

    @Override
    protected boolean getLikelihoodKnown() {
        return false;
    }

    @Override
    public Units.Type getUnits() {
        return this.asnetwork.getUnits();
    }

    @Override
    public void setUnits(Units.Type type) {
    }
}

