/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;

public class CompoundFastMatrixParameter
extends CompoundParameter
implements MatrixParameterInterface {
    private final int rowDimension;
    private int colDimension;
    private final List<MatrixParameterInterface> columns = new ArrayList<MatrixParameterInterface>();
    private final List<Integer> offsets = new ArrayList<Integer>();
    private final List<MatrixParameterInterface> matrices;
    public static final String COMPOUND_FAST_MATRIX_PARAMETER = "compoundFastMatrixParameter";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class, 1, Integer.MAX_VALUE)};

        @Override
        public String getParserName() {
            return CompoundFastMatrixParameter.COMPOUND_FAST_MATRIX_PARAMETER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            ArrayList<MatrixParameterInterface> arrayList = new ArrayList<MatrixParameterInterface>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                arrayList.add((MatrixParameterInterface)xMLObject.getChild(i));
            }
            String string = xMLObject.hasId() ? xMLObject.getId() : null;
            return new CompoundFastMatrixParameter(string, arrayList);
        }

        @Override
        public String getParserDescription() {
            return "A compound matrix parameter constructed from its component parameters.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return CompoundFastMatrixParameter.class;
        }
    };

    public CompoundFastMatrixParameter(String string, List<MatrixParameterInterface> list) {
        super(string, CompoundFastMatrixParameter.compoundMatrices(list));
        this.matrices = list;
        this.rowDimension = list.get(0).getRowDimension();
        this.colDimension = 0;
        for (MatrixParameterInterface matrixParameterInterface : list) {
            if (matrixParameterInterface.getRowDimension() != this.rowDimension) {
                throw new IllegalArgumentException("Inconsistent row dimensions");
            }
            for (int i = 0; i < matrixParameterInterface.getColumnDimension(); ++i) {
                this.columns.add(matrixParameterInterface);
                this.offsets.add(i);
            }
            this.colDimension += matrixParameterInterface.getColumnDimension();
        }
    }

    private static Parameter[] compoundMatrices(List<MatrixParameterInterface> list) {
        int n = 0;
        for (MatrixParameterInterface matrixParameterInterface : list) {
            n += matrixParameterInterface.getUniqueParameterCount();
        }
        Parameter[] parameterArray = new Parameter[n];
        int n2 = 0;
        for (MatrixParameterInterface matrixParameterInterface : list) {
            for (int i = 0; i < matrixParameterInterface.getUniqueParameterCount(); ++i) {
                parameterArray[n2] = matrixParameterInterface.getUniqueParameter(i);
                ++n2;
            }
        }
        return parameterArray;
    }

    @Override
    public Parameter getParameter(int n) {
        return this.columns.get(n).getParameter(this.offsets.get(n));
    }

    @Override
    public double getParameterValue(int n, int n2) {
        return this.columns.get(n2).getParameterValue(n, this.offsets.get(n2));
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        this.columns.get(n2).setParameterValue(n, this.offsets.get(n2), d);
    }

    @Override
    public void setParameterValueQuietly(int n, int n2, double d) {
        this.columns.get(n2).setParameterValueQuietly(n, this.offsets.get(n2), d);
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, int n2, double d) {
        this.columns.get(n2).setParameterValueNotifyChangedAll(n, this.offsets.get(n2), d);
    }

    @Override
    public double[] getColumnValues(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[][] getParameterAsMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public int getColumnDimension() {
        return this.colDimension;
    }

    @Override
    public int getRowDimension() {
        return this.rowDimension;
    }

    @Override
    public int getUniqueParameterCount() {
        return this.getParameterCount();
    }

    @Override
    public Parameter getUniqueParameter(int n) {
        return this.getParameter(n);
    }

    @Override
    public void copyParameterValues(double[] dArray, int n) {
        for (MatrixParameterInterface matrixParameterInterface : this.matrices) {
            matrixParameterInterface.copyParameterValues(dArray, n);
            n += matrixParameterInterface.getRowDimension() * matrixParameterInterface.getColumnDimension();
        }
    }

    @Override
    public void setAllParameterValuesQuietly(double[] dArray, int n) {
        for (MatrixParameterInterface matrixParameterInterface : this.matrices) {
            matrixParameterInterface.setAllParameterValuesQuietly(dArray, n);
            n += matrixParameterInterface.getRowDimension() * matrixParameterInterface.getColumnDimension();
        }
    }

    @Override
    public double[] getParameterValues() {
        int n = 0;
        for (MatrixParameterInterface matrixParameterInterface : this.matrices) {
            n += matrixParameterInterface.getRowDimension() * matrixParameterInterface.getColumnDimension();
        }
        Object object = new double[n];
        this.copyParameterValues((double[])object, 0);
        return object;
    }

    @Override
    public String toSymmetricString() {
        return MatrixParameter.toSymmetricString(this);
    }

    @Override
    public boolean isConstrainedSymmetric() {
        return false;
    }
}

