% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bi_TSLS.R
\name{Bi_TSLS}
\alias{Bi_TSLS}
\title{Bidirectional Two-Stage Least Squares Estimation}
\usage{
Bi_TSLS(data, R_w = 0, R_z = 0)
}
\arguments{
\item{data}{A data frame containing at least these variables:
\itemize{
  \item X: Treatment/exposure variable
  \item Y: Outcome variable
  \item Z: Negative control exposure (proxy variable)
  \item W: Negative control outcome (proxy variable)
  \item At least one additional covariate (required)
}}

\item{R_w}{Sensitivity parameter for W (default = 0)}

\item{R_z}{Sensitivity parameter for Z (default = 0)}
}
\value{
A list containing:
  \itemize{
    \item beta_XY: Estimated effect of X on Y
    \item beta_YX: Estimated effect of Y on X
  }
}
\description{
Performs bidirectional two-stage least squares (Bi-TSLS) estimation to identify
bidirectional causal effects between X and Y using proxy variables Z and W.
Requires at least one covariate in addition to X, Y, Z, and W.
}
\examples{
# Create example data with covariate
n <- 1000
data <- data.frame(
  X = rnorm(n),
  Y = rnorm(n),
  Z = rnorm(n),
  W = rnorm(n),
  V = rnorm(n)  # At least one covariate is required
)

# Run BiTSLS
result <- Bi_TSLS(data)
print(result)
}
