% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exploratory_BifactorIndices.R
\name{bifactorIndices_expl}
\alias{bifactorIndices_expl}
\title{bifactorIndices_expl}
\usage{
bifactorIndices_expl(Lambda, ItemsBySF = NULL, LoadMin = 0.2)
}
\arguments{
\item{Lambda}{is a factor loading matrix from EFA or an object which can be converted to such.
Currently only \code{psych::fa()} objects are supported.}

\item{ItemsBySF}{is a list, indexed by factor, of vectors of item names belonging to each specific
factor. You must NOT include the general factor in this list, and the list must have names which
match the factor names in \code{Lambda}. It is recommended you look at the EFA solution first
to see which factor is which. Defaults to \code{NULL}, in which case composition of specific
factors is automated by comparing loadings to \code{LoadMin}}

\item{LoadMin}{is the minimum loading size so that an item is considered to "belong" to a factor.
If \code{ItemsBySF} is not provided, then items are assigned to factors based on whether their
loading on that factor is greater than \code{LoadMin}. If \code{ItemsBySF} is provided, then
warnings are issued whenever items load above \code{LoadMin} on factors to which they do not belong,
or do not load above \code{LoadMin} on factors to which they do belong, \code{LoadMin} defaults to 0.2.}
}
\value{
A list of bifactor indices, including three different ECV indices, Omega, and
OmegaH.
}
\description{
Computes all available bifactor indices for the input given.
}
\details{
Only standardized models are considered for exploratory models. PUC and ARPB are not
supported for exploratory models currently, although that may change.
}
\examples{

# psych::fa() can not access the rotations We have to load the library.
library(psych)
SRS_BEFA <- fa(SRS_data, nfactors = 5, rotate = "bifactor")

# inspect the solution to see which exploratory factors belong to which subdomain
SRS_BEFA$loadings
ItemsBySF = list(MR4 = paste0("SRS_", c(5, 9, 12, 15, 18)),
                MR2 = paste0("SRS_", c(1, 2, 8, 11, 17)),
                MR3 = paste0("SRS_", c(4, 6, 10, 14, 19)),
                MR5 = paste0("SRS_", c(3, 7, 13, 16, 20)))

bifactorIndices_expl(SRS_BEFA, ItemsBySF = ItemsBySF)
}
\seealso{
\code{\link{bifactorIndices}},
         \code{\link{bifactorIndicesMplus}},
         \code{\link{bifactorIndicesMplus_expl}},
         \code{\link{bifactorIndicesMplus_ESEM}},
         \code{\link{ECV_SS}},
         \code{\link{ECV_SG}},
         \code{\link{ECV_GS}},
         \code{\link{IECV}},
         \code{\link{Omega_S}},
         \code{\link{Omega_H}},
         \code{\link{H}},
         \code{\link{FD}}
}
