% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImportData_hdf5.R
\name{bdImportData_hdf5}
\alias{bdImportData_hdf5}
\title{Import data from URL or file to HDF5 format}
\usage{
bdImportData_hdf5(
  inFile,
  destFile,
  destGroup,
  destDataset,
  header = TRUE,
  rownames = FALSE,
  overwrite = FALSE,
  overwriteFile = FALSE,
  sep = NULL,
  paral = NULL,
  threads = NULL
)
}
\arguments{
\item{inFile}{Character string specifying either a local file path or URL containing
the data to import}

\item{destFile}{Character string specifying the file name and path where the HDF5
file will be stored}

\item{destGroup}{Character string specifying the group name within the HDF5 file
where the dataset will be stored}

\item{destDataset}{Character string specifying the name for the dataset within
the HDF5 file}

\item{header}{Logical or character vector. If TRUE, the first row contains column
names. If a character vector, use these as column names. Default is TRUE.}

\item{rownames}{Logical or character vector. If TRUE, first column contains row
names. If a character vector, use these as row names. Default is FALSE.}

\item{overwrite}{Logical indicating if existing datasets should be overwritten.
Default is FALSE.}

\item{overwriteFile}{Logical indicating if the entire HDF5 file should be
overwritten if it exists. CAUTION: This will delete all existing data.
Default is FALSE.}

\item{sep}{Character string specifying the field separator in the input file.
Default is "\\t" (tab).}

\item{paral}{Logical indicating whether to use parallel computation. Default is TRUE.}

\item{threads}{Integer specifying the number of threads to use for parallel
computation. Only used if paral=TRUE. If NULL, uses maximum available threads.}
}
\value{
No return value. The function writes the data directly to the specified
HDF5 file.
}
\description{
This function downloads data from a URL (if URL is provided) and decompresses it
if needed, then imports the data into an HDF5 file. It supports both local files
and remote URLs as input sources.
}
\examples{
\dontrun{
# Import from local file
bdImportData_hdf5(
  inFile = "data.txt",
  destFile = "output.h5",
  destGroup = "mydata",
  destDataset = "matrix1",
  header = TRUE,
  sep = "\t"
)

# Import from URL
bdImportData_hdf5(
  inFile = "https://example.com/data.csv",
  destFile = "output.h5",
  destGroup = "downloaded",
  destDataset = "remote_data",
  sep = ","
)
}
   
}
