% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdRemove_hdf5_element}
\alias{bdRemove_hdf5_element}
\title{Remove Elements from HDF5 File}
\usage{
bdRemove_hdf5_element(filename, elements)
}
\arguments{
\item{filename}{Character string. Path to the HDF5 file.}

\item{elements}{Character vector. Full paths to elements to remove
(e.g., "group/dataset" or "group/subgroup").}
}
\value{
No return value, called for side effects (element removal).
}
\description{
Removes specified groups or datasets from an HDF5 file.
}
\details{
This function provides safe element removal capabilities with:
\itemize{
\item Removal options:
\itemize{
\item Single element removal
\item Multiple element removal
\item Groups and datasets removal
}
\item Implementation features:
\itemize{
\item Safe file operations
\item Memory-efficient implementation
\item Comprehensive error handling
\item Path validation
}
}

The function validates paths and performs safe removal operations.
}
\examples{
\dontrun{
library(BigDataStatMeth)

# Create test matrices
matA <- matrix(1:15, nrow = 3, byrow = TRUE)
matB <- matrix(15:1, nrow = 3, byrow = TRUE)

# Save to HDF5
fn <- "test.hdf5"
bdCreate_hdf5_matrix(fn, matA, "data", "matrix1",
                     overwriteFile = TRUE)
bdCreate_hdf5_matrix(fn, matB, "data", "matrix2",
                     overwriteFile = FALSE)

# Remove elements
bdRemove_hdf5_element(fn, c("data/matrix1", "data/matrix2"))

# Cleanup
if (file.exists(fn)) {
  file.remove(fn)
}
}

}
\references{
\itemize{
\item The HDF Group. (2000-2010). HDF5 User's Guide.
}
}
\seealso{
\itemize{
\item \code{\link{bdCreate_hdf5_matrix}} for creating HDF5 matrices
}
}
