test_that("brier_score behaves as expected on simple cases", {
  y_true <- factor(c("Active", "Inactive", "Active", "Inactive"),
                   levels = c("Inactive", "Active"))
  # Perfect predictions
  y_prob_perfect <- c(1, 0, 1, 0)
  # Random-ish predictions
  y_prob_random <- c(0.5, 0.5, 0.2, 0.8)

  bs_perfect <- BioMoR::brier_score(y_true, y_prob_perfect, positive = "Active")
  bs_random  <- BioMoR::brier_score(y_true, y_prob_random,  positive = "Active")

  expect_true(bs_perfect <= bs_random)
  expect_equal(bs_perfect, 0)
})
test_that("compute_f1_threshold returns reasonable threshold and F1", {
  y_true <- factor(c("Active", "Inactive", "Active", "Inactive"),
                   levels = c("Inactive", "Active"))
  # Probabilities that separate the classes well
  y_prob <- c(0.9, 0.1, 0.8, 0.2)

  res <- BioMoR::compute_f1_threshold(y_true, y_prob, positive = "Active")

  expect_true(res$threshold >= 0 && res$threshold <= 1)
  expect_true(res$best_f1 > 0)
})
