% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.r
\name{plot_thermal_3d}
\alias{plot_thermal_3d}
\title{Interactive 3D Thermal Surface Plot}
\usage{
plot_thermal_3d(img_obj, use_processed = TRUE)
}
\arguments{
\item{img_obj}{A 'BioThermR' object.}

\item{use_processed}{Logical. If \code{TRUE} (default), uses the 'processed' matrix (where background is likely \code{NA}).
If \code{FALSE}, uses the 'raw' sensor data.}
}
\value{
A \code{plotly} object (HTML widget).
}
\description{
Generates a rotatable, interactive 3D surface plot using the 'plotly' engine.
             This visualization maps temperature to the Z-axis, allowing users to intuitively
             explore the thermal topology, gradients, and intensity of hotspots.
}
\details{
3D visualization is particularly powerful for:
         \itemize{
           \item \strong{Quality Control:} Quickly identifying noise spikes or "cold" artifacts that flat heatmaps might hide.
           \item \strong{Gradient Analysis:} Visualizing how heat dissipates from a central source (e.g., a tumor or inflammation site).
           \item \strong{Presentation:} Creating engaging, interactive figures for HTML reports or Shiny dashboards.
         }
         The output is an HTML widget that allows zooming, panning, and hovering to see specific pixel values.
}
\examples{
\donttest{
# Load raw data
img_obj <- system.file("extdata", "C05.raw", package = "BioThermR")
img <- read_thermal_raw(img_obj)

# Apply automated segmentation
img <- roi_segment_ebimage(img, keep_largest = TRUE)

# 3d plot
plot_thermal_3d(img)
}
}
