% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearestTarget.R
\name{nearestTarget}
\alias{nearestTarget}
\title{Finds the nearest targets to a set of points within a specified radius.}
\usage{
nearestTarget(data, targets, r)
}
\arguments{
\item{data}{An object of class `trajectory` containing a collection of points with coordinates.}

\item{targets}{A matrix or data frame containing the coordinates of the target locations with rows representing targets.}

\item{r}{A numeric value specifying the radius within which to consider targets.}
}
\value{
A data frame with two columns:
\item{nt}{Index of the nearest target for each point. If no target is found within the 
  radius, this will be -1.}
\item{d}{Distance to the nearest target. If no target is found within the radius, this 
  will be -1.}
}
\description{
Calculates the distances between a set of points and target locations. 
It identifies the nearest target for each point and checks if the distance is within 
a specified radius. If a target is found within the radius, its index and distance 
are returned; otherwise, -1 is returned for both.
}
