% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slope_change.R
\name{slope_change}
\alias{slope_change}
\title{This function fits to a numerical vector sorted in the non decreasing order two simple linear regressions and returns the index corresponding to the estimated change between the two regression models.}
\usage{
slope_change(Y)
}
\arguments{
\item{Y}{numerical vector sorted in the non decreasing order.}
}
\value{
K the index corresponding to the estimated change between the two linear regression models.
}
\description{
This function fits to a numerical vector sorted in the non decreasing order two simple linear regressions and returns the index corresponding to the estimated change between the two regression models.
}
\examples{
n <- 30
q <- 100
Sigma <- Simu_Sigma(q = q, diag = FALSE, equal = TRUE)
Matrix::image(Sigma)
E <- matrix(rnorm(n * q), ncol = q) \%*\% chol(as.matrix(Sigma))
corE <- cor(as.matrix(E))
vec_up_emp <- corE[upper.tri(corE)]
G <- matrix(0, ncol = (q - 1), nrow = (q - 1))
G[upper.tri(G, diag = TRUE)] <- vec_up_emp
G[lower.tri(G)] <- t(as.matrix(G))[lower.tri(t(as.matrix(G)))]
res_svd <- svd(G)
vp <- res_svd$d
slope_change(vp)
}
