% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{diabetes}
\alias{diabetes}
\title{Diabetes Data}
\format{
A data frame with 442 rows and 12 variables:
\describe{
\item{X}{Row index}
\item{age}{Age of patient}
\item{sex}{Sex of patient}
\item{bmi}{Body mass index}
\item{map}{Average blood pressure (mean arterial pressure)}
\item{tc}{Total cholesterol (serum measurement)}
\item{ldl}{Low-density lipoproteins (serum measurement)}
\item{hdl}{High-density lipoproteins (serum measurement)}
\item{tch}{Total cholesterol / HDL (serum measurement)}
\item{ltg}{Log of triglycerides (serum measurement)}
\item{glu}{Blood sugar level (serum measurement)}
\item{prog}{Response: quantitative measure of disease progression}
}
}
\source{
\url{https://hastie.su.domains/CASI_files/DATA/diabetes.csv}
}
\description{
Data from 442 diabetes patients used in Section 7.3. The response is a quantitative
measure of disease progression one year after baseline. There are ten baseline
predictors: age, sex, body-mass index, average blood pressure, and six blood
serum measurements.
}
\details{
First used in the LARS paper (Efron et al., 2004).

Note: In Table 7.2, the centered predictor variables were standardized to unit L2
norm. In Table 20.1 they were standardized to unit variance.
}
\examples{
data(diabetes)
str(diabetes)
}
\references{
Efron, B., Hastie, T., Johnstone, I. and Tibshirani, R. (2004). Least Angle Regression.
\emph{Annals of Statistics}, 32(2), 407-499.

Efron, B. and Hastie, T. (2016). \emph{Computer Age Statistical Inference}.
Cambridge University Press, Section 7.3.
}
