% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca_plot.R
\name{caPlot}
\alias{caPlot}
\title{Intepretation-oriented Correspondence Analysis scatterplots, with informative
and flexible (non-overlapping) labels.}
\usage{
caPlot(
  data,
  x = 1,
  y = 2,
  adv.labls = TRUE,
  cntr = "columns",
  percept = FALSE,
  qlt.thres = NULL,
  dot.size = 2.5,
  cex.labls = 3,
  cex.percept = 3
)
}
\arguments{
\item{data}{Contingency table, in dataframe format.}

\item{x}{First of the two desired dimensions to be plotted. 1 is the default.}

\item{y}{Second of the two desired dimensions to be plotted. 2 is the
default.}

\item{adv.labls}{Logical value, which takes TRUE (default) or FALSE if the
user wants or does not want advanced labels to be displayed.}

\item{cntr}{If adv.labls is TRUE, the 'cntr' parameter takes "rows" or
"columns" if the user wants the rows' or columns' contribution to the
selected dimensions to be shown in the scatterplot.}

\item{percept}{Takes TRUE or FALSE (default) if the user does or doesn't want
the scatterplot to be turned into a perceptual map.}

\item{qlt.thres}{Sets the quality of the display's threshold under which
points will not be given labels. NULL is the default.}

\item{dot.size}{Sets the size of the scatterplot's dots. 2.5 is the default.}

\item{cex.labls}{Sets the size of the scatterplot dots' labels. 3 is the
default.}

\item{cex.percept}{Sets the size of the characters displayed in the axes'
labels featuring the perceptual map. 3 is the default.}
}
\description{
This function allows to plot different types of CA scatterplots, adding
information that are relevant to the CA interpretation. Thanks to the
'ggrepel' package, the labels tends to not overlap so producing a nicely
readable chart.
}
\details{
caPlot() provides the facility to produce: \cr (1) a 'regular' (symmetric)
scatterplot, in which points' labels only report the categories' names.

(2) a scatterplot with advanced labels. If the user's interest lies (for
instance) in interpreting the rows in the space defined by the column
categories, by setting the parameter 'cntr' to "columns" the columns' labels
will be coupled with two asterisks within round brackets; each asterisk (if
present) will indicate if the category is a major contributor to the
definition of the first selected dimension (if the first asterisk to the left
is present) and/or if the same category is also a major contributor to the
definition of the second selected dimension (if the asterisk to the right is
present). The rows' labels will report the correlation (i.e., sqrt(COS2))
with the selected dimensions; the correlation values are reported between
square brackets; the left-hand side value refers to the correlation with the
first selected dimensions, while the right-hand side value refers to the
correlation with the second selected dimension. If the parameter 'cntr' is
set to "rows", the row categories' labels will indicate the contribution, and
the column categories' labels will report the correlation values.

(3) a perceptual map, in which axes' poles are given names according to the
categories (either rows or columns, as specified by the user) having a major
contribution to the definition of the selected dimensions; rows' (or
columns') labels will report the correlation with the selected dimensions.

The function returns a dataframe containing data about row and column points:
\cr (a) coordinates on the first selected dimension \cr (b) coordinates on
the second selected dimension \cr (c) contribution to the first selected
dimension \cr (d) contribution to the second selected dimension \cr (e)
quality on the first selected dimension \cr (f) quality on the second
selected dimension \cr (g) correlation with the first selected dimension \cr
(h) correlation with the second selected dimension \cr (j) (k) asterisks
indicating whether the corresponding category is a major contribution to the
first and/or second selected dimension.
}
\examples{
data(brand_coffee)

#displays a 'regular' (symmetric) CA scatterplot, with row and column categories displayed in the 
#same space, and with points' labels just reporting the categories' names. 
#Relevant information (see description above) are stored in the variable 'res'.

res <- caPlot(brand_coffee,1,2,adv.labls=FALSE)

#displays the CA scatterplot, with the columns' labels indicating which category 
# has a major contribution to the definition of the selected dimensions. 
# Rows' labels report the correlation (i.e., sqrt(COS2)) with the selected dimensions.

res <- caPlot(brand_coffee,1,2,cntr="columns")


#displays the CA scatterplot, with the rows' labels indicating 
#which category has a major contribution to the definition of the selected dimensions. 
#Columns' labels report the correlation (i.e., sqrt(COS2)) with the selected dimensions.

res <- caPlot(brand_coffee,1,2,cntr="rows")


#displays the CA scatterplot as a perceptual map; 
#the poles of the selected dimensions will be given names according 
#to the column categories that have a major contribution to the definition 
#of the selected dimensions. Rows' labels report the correlation (i.e., sqrt(COS2)) 
#with the selected dimensions.

res <- caPlot(brand_coffee,1,2,cntr="columns", percept=TRUE)

}
\seealso{
\code{\link{caPercept}} , \code{\link{caPlus}}
}
\keyword{caPlot}
