% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_dim_perm.R
\name{sig.dim.perm}
\alias{sig.dim.perm}
\title{Permuted significance of CA dimensions}
\usage{
sig.dim.perm(data, x = 1, y = 2, B = 999)
}
\arguments{
\item{data}{Name of the dataset (must be in dataframe format).}

\item{x}{First dimension whose significance is calculated (x=1 by default).}

\item{y}{Second dimension whose significance is calculated (y=2 by default).}

\item{B}{Number of permutations (999 by default).}
}
\value{
The function returns a dataframe storing the permuted p-values of each CA dimension.
}
\description{
This function calculates the permuted significance of a pair of selected
CA dimensions. Number of permutation set at 999 by default, but can be
increased by the user. 
A scatterplot of the permuted inertia of a pair of selected dimensions is produced.
Permuted p.values are reported in the axes' labels and are also returned in a dataframe.
}
\examples{
data(greenacre_data)

#Produces a scatterplot of the permuted inertia of the 1 CA dimension
#against the permuted inertia of the 2 CA dimension.
#The observed inertia of the selected dimensions is displayed as a large red dot; 
#pvalues are reported in the axes labels (and are stored in a 'pvalues' object).

pvalues <- sig.dim.perm(greenacre_data, 1,2, B=99)

}
\seealso{
\code{\link{sig.dim.perm.scree}}
}
\keyword{sig.dim.perm}
