% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulate.R
\name{realize}
\alias{realize}
\title{Simulate model realization}
\usage{
realize(
  lambdaX = 6.355e-11,
  alpha1 = 205,
  alpha2 = 3944,
  gamma = 1.971,
  mu = 0.499,
  eta = 0.0127,
  lambdaY = 9.34e-09,
  theta = 0.01052632,
  size = 800,
  edge = 150,
  resolution = 20,
  greyscale = c(255, 255),
  progress = FALSE
)
}
\arguments{
\item{lambdaX}{intensity of the Boolean model mimicking the graphite  particles (default: 0.00000000006355 nm^-3).}

\item{alpha1}{shape parameter of Gamma distribution modeling the length of one semi-axis of the ellipsoidal grain (default: 205 nm).}

\item{alpha2}{shape parameter of Gamma distribution modeling the length of one semi-axis of the ellipsoidal grain (default: 3944 nm).}

\item{gamma}{scale parameter of Gamma distribution modeling the length of all semi-axes of the ellipsoidal grain (default: 1.971).}

\item{mu}{threshold of the excursion set model for the mixture of carbon black and binder (default: 0.499).}

\item{eta}{parameter of the covariance function of the underlying Gaussian random field. This parameter controls how fine the mixture of carbon black and binder is (default: 0.0127 nm^-1).}

\item{lambdaY}{intensity of the Boolean model mimicking the large pore regions (default: 0.000000009340 nm^-3).}

\item{theta}{rate parameter of the Exponential distribution modeling the radii of large pores (default: 0.01052632 nm^-1).}

\item{size}{the size of the cubic grid, on which the model is simulated (default: 800).}

\item{edge}{the amount of edge correction used for model simulation (default: 150). The model is realized on a cubic grid, which is extended in each direction by a ceretain number of additional grid points, given by the parameter edge. This avoids edge effects at the boundary.}

\item{resolution}{the physical distance between to grid points in nm (default: 20). Be careful with changing resolutions, see Figure 5 and the  corresponding discussion in Gräfensteiner et al. 2024.}

\item{greyscale}{this parameter is a 2D vector, which contains the labels for the mixture of carbon black and binder (first entry) and graphite particles (second entry). Note that the pores are always labeled with zero. (default: (255, 255))}

\item{progress}{Binary parameter. If true, information regarding the progress of the current model realization is printed. (default: FALSE)}
}
\value{
Returns a model realization in form of a cubic 3D matrix. The length in each direction is given by the parameter 'size'. At each gridpoint the greyscale value of the corresponding phase is stored. The value 0 indicates pores, while the parameters 'greyscale[1]' and 'greyscale[2]' indicate the carbon black/binder-mixture and the graphite particles, respectively.
}
\description{
Simulates a realization of the stochastic 3D structure model on a 3D grid. The default parameters are those fitted to 3D image data of particular cathode material in Gräfensteiner et al. 2024. For a detailed interpretation of model parameters, we refer to Section 3.1.5.
}
\examples{
Xi <- realize(size = 10, edge = 10)
}
\references{
P. Gräfensteiner, M. Osenberg, A. Hilger, N. Bohn, J. R. Binder, I. Manke, V. Schmidt, M. Neumann (2024) <doi:10.48550/arXiv.2409.11080>
}
