% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBPLinearE.R
\name{CBPLinearE}
\alias{CBPLinearE}
\title{Correlation-based Estimator for Linear Regression Models}
\usage{
CBPLinearE(X, y, lambda)
}
\arguments{
\item{X}{A numeric matrix of predictors where rows represent observations and columns represent variables.}

\item{y}{A numeric vector of response variables.}

\item{lambda}{A regularization parameter.}
}
\value{
A numeric vector of the estimated coefficients for the specified model.
}
\description{
This function computes the correlation-based estimator for linear regression models.
}
\details{
The correlation-based penalized linear estimator is calculated as:
\deqn{
\hat{\beta} =  \text{argmin} \left\{ \sum_{i=1}^n (y_i - \mathbf{x}_i^\top \boldsymbol{\beta})^2 + \lambda \sum_{i=1}^{p-1} \sum_{j>i} \left( \frac{(\beta_i - \beta_j)^2}{1 - \rho_{ij}} + \frac{(\beta_i + \beta_j)^2}{1 + \rho_{ij}} \right) \right\}
}
where \eqn{\rho_{ij}} denotes the (empirical) correlation between the \eqn{i}th and the \eqn{j}th predictor.
}
\examples{
set.seed(42)
n <- 100
p <- 4
X <- matrix(rnorm(n * p), n, p)
beta_true <- c(0.5, -1, 2, 5)
y <- X \%*\% beta_true + rnorm(n)
lambda <- 0.1

result <- CBPLinearE(X, y, lambda = lambda)
print(result)

}
\references{
Tutz, G., Ulbricht, J. (2009). Penalized regression with correlation-based penalty. Stat Comput 19, 239–253.
}
