% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCSRfind.R
\name{CCSRfind}
\alias{CCSRfind}
\title{Identify CCSR codes corresponding to ICD-10 codes}
\usage{
CCSRfind(workset, dxs, example = FALSE)
}
\arguments{
\item{workset}{Dataset with ICD-10 codes}

\item{dxs}{List of column name(s) of ICD-10 codes within workset}

\item{example}{indicator if running an example, default is FALSE}
}
\value{
A list of CCSR codes corresponding to the ICD-10 codes
}
\description{
Identify CCSR codes corresponding to ICD-10 codes
}
\examples{

# Example dataset
id<-c(1:2)
dx1<-c("A000","B0189")
dx2<-c("A157","E133591")
workset<-data.frame(id,dx1,dx2)

dxs<-c("dx1","dx2")

# Convert to CCSR codes
CCSRfind(workset=workset,dxs=dxs,example=TRUE)
}
