% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_corr_fs.R
\name{CGGP_internal_CorrMatWendland0}
\alias{CGGP_internal_CorrMatWendland0}
\title{Wendland0 (Triangle) correlation function}
\usage{
CGGP_internal_CorrMatWendland0(
  x1,
  x2,
  theta,
  return_dCdtheta = FALSE,
  return_numpara = FALSE,
  returnlogs = FALSE
)
}
\arguments{
\item{x1}{Vector of coordinates from same dimension}

\item{x2}{Vector of coordinates from same dimension}

\item{theta}{Correlation parameters:
\itemize{
    \item LS Log of parameter that controls lengthscale
    \item FD Logit of 0.5*parameter  that controls the fractal dimension
    \item HE Log of parameter that controls the hurst effect
}}

\item{return_dCdtheta}{Should dCdtheta be returned?}

\item{return_numpara}{Should it just return the number of parameters?}

\item{returnlogs}{Should log of correlation be returned?}
}
\value{
Matrix of correlation values between x1 and x2
}
\description{
Calculate correlation matrix for two sets of points in one dimension.
Note that this is not the correlation between two vectors.
}
\examples{
CGGP_internal_CorrMatWendland0(c(0,.2,.4),c(.1,.3,.5), theta=-.7)
}
\seealso{
Other correlation functions: 
\code{\link{CGGP_internal_CorrMatCauchySQT}()},
\code{\link{CGGP_internal_CorrMatCauchySQ}()},
\code{\link{CGGP_internal_CorrMatCauchy}()},
\code{\link{CGGP_internal_CorrMatGaussian}()},
\code{\link{CGGP_internal_CorrMatMatern32}()},
\code{\link{CGGP_internal_CorrMatMatern52}()},
\code{\link{CGGP_internal_CorrMatPowerExp}()},
\code{\link{CGGP_internal_CorrMatWendland1}()},
\code{\link{CGGP_internal_CorrMatWendland2}()}
}
\concept{correlation functions}
