% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGR.R
\name{CGR}
\alias{CGR}
\title{CGR}
\usage{
CGR(variable, data, verbose = FALSE)
}
\arguments{
\item{variable}{Time series data taken for the study}

\item{data}{Name of the data taken for the study}

\item{verbose}{Logical. If TRUE, the function prints detailed information about its progress. Default is FALSE.}
}
\value{
Returns a list containing the Compound growth rate for capturing the growth rated over the period  and other model parameters.
The list includes:
\itemize{
  \item \code{CGR}: Growth rate calculated for the data.
  \item \code{AoS}: The value derived by taking anti log of the slope of exponential model.
}
}
\description{
Compound Growth Rate for Capturing the Growth Rate Over the Period
}
\examples{
{
library(CGR)
years <- 1:50
value<-rnorm(length(years),100, 50)
data <- data.frame(Year = years, Sales = round(value))
CGR_results <- CGR(variable = data$Sales, data = data)
print(CGR_results)
}
}
\references{
#' \itemize{
\item •	Shankar, S. V., Chandel, A., Gupta, R. K., Sharma, S., Chand, H., Kumar, R., ... & Gowsar, S. N. (2023). Corrigendum: Exploring the dynamics of arrivals and prices volatility in onion (Allium cepa) using advanced time series techniques. Frontiers in Sustainable Food Systems, 7, 1290515. DOI: 10.3389/fsufs.2023.1208898
}
}
