% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_estimates_bootstrap.R
\name{bootstrap_se}
\alias{bootstrap_se}
\title{Bootstrap standard error estimates}
\usage{
bootstrap_se(setting = "GLM", BS_rep = 1000, Y = NULL, X = NULL,
  K = NULL, L = NULL, C = NULL)
}
\arguments{
\item{setting}{String with value \code{"GLM"} or \code{"AFT"} indicating
whether standard error estimates are obtained for a
normally-distributed (\code{"GLM"}) or censored time-to-event
(\code{"AFT"}) primary outcome \code{Y}.}

\item{BS_rep}{Integer indicating the number of bootstrap samples that are drawn.}

\item{Y}{Numeric input vector for the primary outcome.}

\item{X}{Numeric input vector for the exposure variable.}

\item{K}{Numeric input vector for the intermediate outcome.}

\item{L}{Numeric input vector for the observed confounding factor.}

\item{C}{Numeric input vector for the censoring indicator under the AFT setting
(must be coded 0 = censored, 1 = uncensored).}
}
\value{
Returns a vector with the bootstrap standard error estimates
        of the parameter estimates.
}
\description{
Function to obtain bootstrap standard error estimates for the parameter
estimates of the \code{\link{get_estimates}} function, under the generalized
linear model (GLM) or accelerated failure time (AFT) setting for the analysis
of a normally-distributed or censored time-to-event primary outcome.
}
\details{
Under the GLM setting for the analysis of a normally-distributed primary
outcome Y, bootstrap standard error estimates are obtained for the estimates
of the parameters
\eqn{\alpha_0, \alpha_1, \alpha_2, \alpha_3, \sigma_1^2, \alpha_4, \alpha_{XY}, \sigma_2^2}{\alpha0, \alpha1, \alpha2, \alpha3, \sigma1^2, \alpha4, \alphaXY, \sigma2^2}
in the models
\deqn{Y = \alpha_0 + \alpha_1 \cdot K + \alpha_2 \cdot X + \alpha_3 \cdot L + \epsilon_1, \epsilon_1 \sim N(0,\sigma_1^2)}{Y = \alpha0 + \alpha1*K + \alpha2*X + \alpha3*L + \epsilon1, \epsilon1 ~ N(0,\sigma1^2)}
\deqn{Y^* = Y - \overline{Y} - \alpha_1 \cdot (K-\overline{K})}{Y* = Y - mean(Y) - \alpha1*(K-mean(K))}
\deqn{Y^* = \alpha_0 + \alpha_{XY} \cdot X + \epsilon_2, \epsilon_2 \sim N(0,\sigma_2^2),}{Y* = \alpha0 + \alphaXY*X + \epsilon2, \epsilon2 ~ N(0,\sigma2^2),}
accounting for the additional variability from the 2-stage approach.

Under the AFT setting for the analysis of a censored time-to-event primary
outcome, bootstrap standard error estimates are similarly obtained of the
parameter estimates of
\eqn{\alpha_0, \alpha_1, \alpha_2, \alpha_3, \sigma_1, \alpha_4, \alpha_{XY}, \sigma_2^2}{\alpha0, \alpha1, \alpha2, \alpha3, \sigma1, \alpha4, \alphaXY, \sigma2^2}
}
\examples{

dat <- generate_data(setting = "GLM", n = 100)

# For illustration use here only 100 bootstrap samples, recommended is using 1000
bootstrap_se(setting = "GLM", BS_rep = 100, Y = dat$Y, X = dat$X,
             K = dat$K, L = dat$L)

}
