% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cin_metrics.R
\name{CINmetrics}
\alias{CINmetrics}
\title{CINmetrics}
\usage{
CINmetrics(
  cnvData,
  segmentMean_tai = 0.2,
  segmentMean_cna = (log(1.7, 2) - 1),
  segmentMean_base_segments = 0.2,
  segmentMean_break_points = 0.2,
  segmentMean_fga = 0.2,
  numProbes = NA,
  segmentDistance_cna = 0.2,
  minSegSize_cna = 10,
  genomeSize_fga = 2873203431
)
}
\arguments{
\item{cnvData}{dataframe containing following columns: Sample, Start, End, Num_Probes, Segment_Mean}

\item{segmentMean_tai}{numerical value for the minimum segment_mean cutoff/ threshold for Total Aberration Index calculation. Default is 0.2}

\item{segmentMean_cna}{numerical value for the minimum segment_mean cutoff/ threshold for Copy Number Aberration calculation. Default is 0.2}

\item{segmentMean_base_segments}{numerical value for the minimum segment_mean cutoff/ threshold for Base segments calculation. Default is 0.2}

\item{segmentMean_break_points}{numerical value for the minimum segment_mean cutoff/ threshold for Break points calculation. Default is 0.2}

\item{segmentMean_fga}{numerical value for the minimum segment_mean cutoff/ threshold for Fraction of genome altered calculation. Default is 0.2}

\item{numProbes}{Number of Probes}

\item{segmentDistance_cna}{Segment distance threshold}

\item{minSegSize_cna}{Minimum segment size}

\item{genomeSize_fga}{Size of the genome derived from Affymetrix 6.0 array probe. Default is 2873203431 calculated based on hg38 **excluding sex chromosomes**}
}
\value{
All Chromosomal INstability metrics
}
\description{
Calculate all CINmetrics on a given dataframe
}
\examples{
CINmetrics(cnvData = maskCNV_BRCA)
}
