% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cin_metrics.R
\name{cna}
\alias{cna}
\title{Copy Number Aberration}
\usage{
cna(
  cnvData,
  segmentMean = (log(1.7, 2) - 1),
  numProbes = NA,
  segmentDistance = 0.2,
  minSegSize = 10
)
}
\arguments{
\item{cnvData}{dataframe containing following columns: Sample, Start, End, Num_Probes, Segment_Mean}

\item{segmentMean}{numerical value for the minimum segment_mean cutoff/ threshold. Default is 0.2}

\item{numProbes}{Number of Probes}

\item{segmentDistance}{Segment distance threshold}

\item{minSegSize}{Minimum segment size}
}
\value{
Number of copy number aberrations between segments
}
\description{
Calculates the number of copy number aberrations
}
\details{
Copy Number Aberrations (CNA) \href{https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0079079}{(Davidson JM, et al)}, are defined as a segment with copy number outside the pre-defined range of 1.7-2.3 \deqn{(\log_2 1.7 -1) \le \bar{y}_{S_i} \le (\log_2 2.3 -1)} that is not contiguous with an adjacent independent CNA of identical copy number. For our purposes, we have adapted the range to be \deqn{|\bar{y}_{S_i}| \ge |\log_2 1.7|}, which is only slightly larger than the original.
It is nearly identical to countingBreakPoints, except this one calculates breaks as adjacent segments that have a difference in segment means of \eqn{\ge 0.2}.
\deqn{Total\ Copy\ Number\ Aberration = \sum^{R}_{i = 1} n_i \ where \
\bar{y}_{S_i}| \ge |\log_2{1.7}|, \
\bar{y}_{S_{i-1}} - \bar{y}_{S_i}| \ge 0.2, \
d_i \ge 10}
}
\examples{
cna(cnvData = maskCNV_BRCA)
}
\seealso{
\code{\link{countingBreakPoints}}
}
