% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Crossplots.functions.R
\name{draw.squareplots}
\alias{draw.squareplots}
\title{Draw Square Plots}
\usage{
draw.squareplots(
  fn.mean.A,
  fn.mean.B,
  fn.sd.A,
  fn.sd.B,
  fn.pe.mean,
  fn.pe.sd,
  variables,
  ishybrid,
  num.vars
)
}
\arguments{
\item{fn.mean.A}{file name of file with confidence intervals of mean stress, environment level A data. Can be either hybrid or inbred data.}

\item{fn.mean.B}{file name of file with confidence intervals of mean stress, environment level B data. Can be either hybrid or inbred data.}

\item{fn.sd.A}{file name of file with confidence intervals of SD stress, environment level A data. Can be either hybrid or inbred data.}

\item{fn.sd.B}{file name of file with confidence intervals of SD stress, environment level B data. Can be either hybrid or inbred data.}

\item{fn.pe.mean}{file name of file with point estimates of mean for each gene (both A and B environment levels present). Can be either hybrid or inbred data.}

\item{fn.pe.sd}{file name of file with point estimates of SD for each gene (both A and B environment levels present). Can be either hybrid or inbred data.}

\item{variables}{list of variables from mean and variance models. Mean vars needs to be listed first, then variance vars.}

\item{ishybrid}{indicates the type of the data set being examined. Choose 'Hybrid' or 'Inbred' or "All".}

\item{num.vars}{number of variables per model. Used to ascertain if a variable falls in the mean or the variance model.}
}
\value{
There is no return for this function; it prints square plots for each of the variables listed in the parameter 'variables'.
}
\description{
This function draws square plots for As and Bs in each variable in the mean and variance models with the Mean Estimate vs Standard Deviation Estimate
}
\examples{
test.data <- simu.inter.dat.interboth(n.rep = 3, n.obs.per.rep = 15, ran.seed = 1)
variables <- colnames(test.data[-1])
mean_stress(test.data, variables, 'stress')
sink();
sd.stress(test.data, variables, 'stress')
sink();
bootstrap(test.data, n.boot=100,variables, 'stress')
plot_vars <- c("loci_var.4","loci_var.7.env_var.2","loci_var.3",
"loci_var.5","loci_var.8.env_var.2","loci_var.4")
draw.squareplots('bootstrap mean A stress.txt','bootstrap mean B stress.txt',
'bootstrap sd A stress.txt', 'bootstrap sd B stress.txt', 'mean_stress.txt',
'sd_stress.txt', plot_vars, 'All', 3)
unlink(c('bootstrap mean A stress.txt','bootstrap mean B stress.txt',
'bootstrap sd A stress.txt', 'bootstrap sd B stress.txt',
'mean_stress.txt', 'sd_stress.txt'))
}
