% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulationStudyFunctions.R
\name{gg.score.norm.plot}
\alias{gg.score.norm.plot}
\title{Function for plotting chordal norms between estimated and true subject score subspaces within the simulation study described in CJIVE manuscript}
\usage{
gg.score.norm.plot(
  norm.dat,
  cols,
  show.legend = FALSE,
  text.size,
  lty = 1,
  y.max = 1,
  x.lab.angle = 70
)
}
\arguments{
\item{norm.dat}{data frame with at least the 5 following variables:
Norm - the value of the norm for a particular subspace;
Type - the subspace for which the norm is given (i.e., joint and individual subject scores for dataset X1 or X2 (except joint scores, which are for both datasets))
Method - the method by which the subspace was estimated, e.g. CJIVE, AJIVE, R.JIVE
JVE_1 and JVE_2 - labels describing the proportion of joint variation explained in each dataset (and typically the number of variables in dataset X2)}

\item{cols}{a vector of colors, must have length equal to the number of methods used in the simulation}

\item{show.legend}{logical (TRUE/FALSE) for whether a legend should be included in the plot. Default is FALSE}

\item{text.size}{numeric value for the font size}

\item{lty}{linetype (see ggplot2). Default = 1}

\item{y.max}{maximum value for the horizontal axis of the plot}

\item{x.lab.angle}{angle at which x-axis labels are tilted}
}
\value{
graphical display (via ggplot2)
}
\description{
Graphically displays the center and spread of chordal norms for joint/individual subject score subspaces
}
