% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CKAT.R
\name{CKAT}
\alias{CKAT}
\title{Composite kernel association test for SNP-set analysis in pharmacogenetics (PGx) studies.}
\usage{
CKAT(G, Tr, X, y, trait = "continuous", ker = "linear", grids = c(0,
  0.5, 1), n_a = 1000, method = "liu", subdiv = 10^6)
}
\arguments{
\item{G}{- genotype matrix.}

\item{Tr}{- treatment vector, 0 indicates placebo, 1 indicates treatment.}

\item{X}{- non-genetic covariates data matrix.}

\item{y}{- response vector. Currently continuous and binary responses are supported. Survival response will be added soon.}

\item{trait}{- response indicator. trait = "continuous" or "binary".}

\item{ker}{- kernel. ker = "linear", "IBS", "Inter" (interaction kernel) and "RBF" (radial basis function kernel).}

\item{grids}{- grids of the candidate weights.}

\item{n_a}{- the number of intervals for manual integration (when integrate function fails). Default n_a = 1000.}

\item{method}{- method for getting density of A (see details in the reference). Default method is Liu's method.}

\item{subdiv}{- parameter of Davies' method. Default value is 1E6.}
}
\value{
pvals - p-values of each individual association test.

finalp - final p-value of the CKAT test.
}
\description{
Composite kernel association test for SNP-set analysis in pharmacogenetics (PGx) studies.
}
\examples{
nsamples = 500; nsnps = 10
X = rnorm(nsamples,0,1)
Tr = sample(0:1,nsamples,replace=TRUE)
G = matrix(rbinom(nsamples*nsnps, 1, 0.05), nrow = nsamples, ncol = nsnps)
GxT = G*Tr
Y0 = 0.5*X + Tr + rnorm(nsamples)
CKAT(G, Tr, X, Y0, grids=c(0,0.5,1))
}
