% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_bayes.R
\name{diagnostic_bayes}
\alias{diagnostic_bayes}
\title{Generate MCMC Diagnostic Plots for a Bayesian Model}
\usage{
diagnostic_bayes(model, var.param)
}
\arguments{
\item{model}{A fitted Bayesian model object created with \code{rstan::stan()}.}

\item{var.param}{A character vector specifying the names of the model parameters (e.g., slopes or coefficients)
to include in the trace and rank plots.}
}
\value{
A list of four ggplot2 objects:
\describe{
\item{plot_rhat}{A histogram of Rhat values (\code{mcmc_rhat_hist}).}
\item{plot_neff}{A histogram of effective sample sizes (\code{mcmc_neff_hist}).}
\item{plot_trace}{Trace plots of the MCMC chains for selected parameters (\code{mcmc_trace}).}
\item{plot_trank}{Rank plots of the selected parameters across chains (\code{mcmc_rank_overlay}).}
}
}
\description{
Produces a set of standard diagnostic plots to evaluate convergence and sampling efficiency
for a Bayesian model fitted using \code{rstan}.
}
\details{
This function uses the \code{bayesplot} package to visualize diagnostics commonly used to assess
convergence and sampling performance in MCMC estimation.
}
