% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stukels_test.R
\name{stukels_test}
\alias{stukels_test}
\title{Stukel’s Test for Logistic Regression Model Fit}
\usage{
stukels_test(model)
}
\arguments{
\item{model}{A fitted logistic regression model of class \code{glm}.}
}
\value{
A list with the following components:
\item{G}{Likelihood ratio test statistic for added z1 and z2.}
\item{p_value}{P-value for the likelihood ratio test.}
\item{model_summary}{Summary of the logistic regression model including z1 and z2.}
}
\description{
This function performs Stukel’s test to assess the goodness-of-fit of a logistic regression model,
as adapted from Hosmer et al. (2013) by using the likelihood ratio test .
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 5, Section 5.2.2

# Recode 'raterisk' into a binary variable 'raterisk_cat'
glow500 <- dplyr::mutate(
  glow500,
  raterisk_cat = dplyr::case_when(
    raterisk \%in\% c("Less", "Same") ~ "C1",
    raterisk == "Greater" ~ "C2"
  )
)

# Fit a multiple logistic regression model with interactions
model.int <- glm(
  fracture ~ age + height + priorfrac + momfrac + armassist +
    raterisk_cat + age * priorfrac + momfrac * armassist,
  family = binomial,
  data = glow500
)

# Apply the Stukels test for goodness-of-fit
stukels_test(model.int)

}
\references{
Hosmer, D. W., Lemeshow, S., & Sturdivant, R. X. (2013). \emph{Applied Logistic Regression} (3rd ed.).
John Wiley & Sons, Inc.
}
