% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determineNumSigs.R
\name{determineNumSigs}
\alias{determineNumSigs}
\title{determineNumSigs}
\usage{
determineNumSigs(
  scm,
  rmin = 3,
  rmax = 12,
  cores = 1,
  nrun = 250,
  saveRes = FALSE,
  saveDir = NULL,
  runName = ""
)
}
\arguments{
\item{scm}{Sample by component matrix used to find signatures}

\item{rmin}{The lower bound of signature numbers to check. Default is 2.}

\item{rmax}{The upper bound of signature numbers to check. Default is 12.}

\item{cores}{The number of cores to use for parallel analysis. Default is 1.}

\item{nrun}{Number of runs for NMF. Default is 250.}

\item{saveRes}{Whether or not to save the plot. Default is FALSE.}

\item{saveDir}{Directory to save plot in, must be provided if using saveDir}

\item{runName}{Used to title plots and files when saving results}
}
\value{
Creates a series of plots to help user decide
}
\description{
This function uses the extracted features and modelled components, and it
performs NMF on these ranging from the minimum number of signatures to the
max. It repeats this on randomized data and computes various measures to
help inform the user on how many signatures to proceed with. This function
may take a while to run since it repeats the NMF process many times. It is 
suggested to give it multiple cores to allow for parallel processing.
}
\examples{
\donttest{
determineNumSigs(generateSCM(featsExp,compsExp))}
}
\keyword{number}
\keyword{of}
\keyword{signatures}
\keyword{signum}
