% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{Aggregate.purse}
\alias{Aggregate.purse}
\title{Aggregate indicators}
\usage{
\method{Aggregate}{purse}(
  x,
  dset,
  f_ag = NULL,
  w = NULL,
  f_ag_para = NULL,
  dat_thresh = NULL,
  write_to = NULL,
  by_df = FALSE,
  ...
)
}
\arguments{
\item{x}{A purse-class object}

\item{dset}{The name of the data set to apply the function to, which should be accessible in \code{.$Data}.}

\item{f_ag}{The name of an aggregation function, a string. This can either be a single string naming
a function to use for all aggregation levels, or else a character vector of function names of length \code{n-1}, where \code{n} is
the number of levels in the index structure. In this latter case, a different aggregation function may be used for each level
in the index: the first in the vector will be used to aggregate from Level 1 to Level 2, the second from Level 2 to Level 3, and
so on.}

\item{w}{An optional data frame of weights. If \code{f_ag} does not require accept weights, set to \code{"none"}. Alternatively, can be the
name of a weight set found in \code{.$Meta$Weights}. This can also be specified as a list specifying the aggregation weights for each
level, in the same way as the previous parameters.}

\item{f_ag_para}{Optional parameters to pass to \code{f_ag}, other than \code{x} and \code{w}. As with \code{f_ag}, this can specified to have different
parameters for each aggregation level by specifying as a nested list of length \code{n-1}. See details.}

\item{dat_thresh}{An optional data availability threshold, specified as a number between 0 and 1. If a row
within an aggregation group has data availability lower than this threshold, the aggregated value for that row will be
\code{NA}. Data availability, for a row \code{x_row} is defined as \code{sum(!is.na(x_row))/length(x_row)}, i.e. the
fraction of non-\code{NA} values. Can also be specified as a vector of length \code{n-1}, where \code{n} is
the number of levels in the index structure, to specify different data availability thresholds by level.}

\item{write_to}{If specified, writes the aggregated data to \code{.$Data[[write_to]]}. Default \code{write_to = "Aggregated"}.}

\item{by_df}{Controls whether to send a numeric vector to \code{f_ag} (if \code{FALSE}, default) or a data frame (if \code{TRUE}) - see
details. Can also be specified as a logical vector of length \code{n-1}, where \code{n} is
the number of levels in the index structure.}

\item{...}{arguments passed to or from other methods.}
}
\value{
An updated purse with new treated data sets added at \code{.$Data[[write_to]]} in each coin.
}
\description{
Aggregates indicators following the structure specified in \code{iMeta}, for each coin inside the purse.
See \code{\link[=Aggregate.coin]{Aggregate.coin()}}, which is applied to each coin, for more information
}
\examples{
# build example purse up to normalised data set
purse <- build_example_purse(up_to = "Normalise", quietly = TRUE)

# aggregate using defaults
purse <- Aggregate(purse, dset = "Normalised")

}
