% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bar.R
\name{plot_bar}
\alias{plot_bar}
\title{Bar chart}
\usage{
plot_bar(
  coin,
  dset,
  iCode,
  ...,
  uLabel = "uCode",
  axes_label = "iCode",
  by_group = NULL,
  filter_to_ends = NULL,
  dset_label = FALSE,
  log_scale = FALSE,
  stack_children = FALSE,
  bar_colours = NULL,
  flip_coords = FALSE
)
}
\arguments{
\item{coin}{A coin object.}

\item{dset}{Data set from which to extract the variable to plot. Passed to \code{\link[=get_data]{get_data()}}.}

\item{iCode}{Code of variable or indicator to plot. Passed to \code{\link[=get_data]{get_data()}}.}

\item{...}{Further arguments to pass to \code{\link[=get_data]{get_data()}}, e.g. for filtering units.}

\item{uLabel}{How to label units: either \code{"uCode"}, or \code{"uName"}.}

\item{axes_label}{How to label the y axis and group legend: either \code{"iCode"} or \code{"iName"}.}

\item{by_group}{Optional group variable to use to colour bars. Cannot be used if \code{stack_children = TRUE}.}

\item{filter_to_ends}{Optional way to filter the bar chart to only display the top/bottom N units. This is useful in cases
where the number of units is large. Specify as e.g. \code{list(top = 10)} or \code{list(bottom = 10)} to return only the top or bottom
ten units respectively (the value 10 can be changed of course).}

\item{dset_label}{Logical: whether to include the data set in the y axis label.}

\item{log_scale}{Logical: if \code{TRUE} uses a log scale for the y axis.}

\item{stack_children}{Logical: if \code{TRUE} and \code{iCode} refers to an aggregate, will plot \code{iCode} with each bar split into
its underlying component values (the underlying indicators/aggregates used to create \code{iCode}). To use this, you must
have aggregated your data and \code{dset} must point to a data set where the underlying (child) scores of \code{iCode} are available.}

\item{bar_colours}{Optional vector of colour codes for colouring bars.}

\item{flip_coords}{Logical; if \code{TRUE} flips to horizontal bars.}
}
\value{
A ggplot2 plot object.
}
\description{
Plot bar charts of single indicators. Bar charts can be coloured by an optional grouping variable \code{by_group}, or if
\code{iCode} points to an aggregate, setting \code{stack_children = TRUE} will plot \code{iCode} coloured by its underlying scores.
}
\details{
This function uses ggplot2 to generate plots, so the plot can be further manipulated using ggplot2 commands.
See \verb{vignette("visualisation}) for more details on plotting.
}
\examples{
# build example coin
coin <- build_example_coin(up_to = "new_coin", quietly = TRUE)

# bar plot of CO2 by GDP per capita group
plot_bar(coin, dset = "Raw", iCode = "CO2",
         by_group = "GDPpc_group", axes_label = "iName")
}
