% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get.control}
\alias{get.control}
\title{Construct a control object to pass additional arguments to a number of
functions in the package.}
\usage{
get.control(
  ymax = 1e+06,
  optim.method = "L-BFGS-B",
  optim.control = list(maxit = 150),
  hybrid.tol = 0.01,
  truncate.tol = 1e-06
)
}
\arguments{
\item{ymax}{Truncate counts to maximum value of \code{y}.}

\item{optim.method}{Optimization method for maximum likelihood. See the
\code{method} argument in \link[stats]{optim}.}

\item{optim.control}{\code{control} argument for \link[stats]{optim}.}

\item{hybrid.tol}{Tolerance to decide when to use truncation method versus
approximation method to compute quantities based on the normalizing constant.
See details.}

\item{truncate.tol}{Tolerance for truncation method. See details.}
}
\value{
List of controls.
}
\description{
Construct a control object to pass additional arguments to a number of
functions in the package.
}
\details{
A hybrid method is used throughout the package to compute the CMP normalizing
constant and related quantities. When \eqn{\lambda^{-1/\nu}} is smaller than
\code{hybrid.tol}, an asymptotic approximation is used; otherwise, infinite
series are truncated to finite summations. More information is given in the
\code{COMPoissonReg} vignette.

The element \code{ymax} protects against very long computations. Users
should beware when increasing this significantly beyond the default, as it
may result in a session which needs to be terminated.
}
