% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootbiascorrect.R
\name{bootbiascorrect}
\alias{bootbiascorrect}
\title{Implements Bootstrap Bias Correction}
\usage{
bootbiascorrect(changeP, time, event, censoring, censpoint, intwd, cpmax, cpmin,
  norm.riskset, B.correct, parametric, times.int, opt.start)
}
\arguments{
\item{changeP}{Estimated change point.}

\item{time}{Numeric vector with survival times.}

\item{event}{Numeric vector indicating censoring status; 0 = alive (censored), 1 =
dead (uncensored). If missing, all observations are assumed to be
uncensored.}

\item{censoring}{Type of right-censoring for simulated data on which the
bootstrap bias correction is based. Possible types are "random" for
\emph{random censoring} (default), "type1" for \emph{Type I censoring} or
"no" for data without censored observations. Because simulated data should
be similar to given data, the censoring type is adapted from vector
'events' if given and argument 'censoring' is ignored than.}

\item{censpoint}{Point of \emph{Type I censoring}; if missing, minimum time
after which all events are equal to 0 is used. Censpoint is only needed for
bootstrap bias correction.}

\item{intwd}{Width of intervals into which the time period is split; default
is \code{ceiling(cpmax/20)}. Has to be an integer value.}

\item{cpmax}{Upper bound for estimated change point. Time period is split into
intervals up to this point. Has to be an integer value.}

\item{cpmin}{Lower bound for estimated change point; default is
\code{cpmin=0}. Has to be an integer value.}

\item{norm.riskset}{Logical; if \code{TRUE} normalized number of units at
risk is used within an interval.}

\item{B.correct}{Number of bootstrap samples for bias correction; defaults to
49.}

\item{parametric}{Logical; if \code{TRUE} parametric bootstrap bias
correction is used (simulation of boostrap samples is based on estimated
Weibull parameters); otherwise Kaplan-Meier is used for a nonparametric
bootstrap bias correction.}

\item{times.int}{Logical; if \code{TRUE} simulated survival times are
integers.}

\item{opt.start}{Numeric vector of length two; initial values for the Weibull
parameters (shape and scale parameters) to be optimized if parametric bootstrap
bias correction is used.}
}
\value{
A list with bias-corrected change point and optional estimated shape
  and scale parameters of the Weibull distribution.
}
\description{
Implements Bootstrap Bias Correction
}
