% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.cpsurv}
\alias{plot.cpsurv}
\title{Plot method for objects of class cpsurv}
\usage{
\method{plot}{cpsurv}(x, type = "all", ci = TRUE, ci.type = c("perc",
  "norm"), const.haz = TRUE, regline = TRUE, legend = TRUE, xlim = NULL,
  ylim = NULL, main = NULL, xlab = NULL, ylab = NULL, min.time,
  max.time, n.est.grid = 101, ask = TRUE, ...)
}
\arguments{
\item{x}{An object of class 'cpsurv' (estimated with \code{cpsurv}).}

\item{type}{A vector of character strings to select the plots for printing.
The value should be any subset of the values c("pvals", "events", "hazard")
or simply "all", where all possible plots are shown.}

\item{ci}{Logical; if \code{TRUE}, a bootstrap confidence interval is plotted
(if existing).}

\item{ci.type}{Character representing the type of confidence interval to plot
(if existing); "perc" for percentile interval and "norm" for CI with normal
approximation (default is "perc").}

\item{const.haz}{Logical; if \code{TRUE}, the estimated constant hazardrate
is plotted.}

\item{regline}{Logical; if \code{TRUE}, the regression line is plotted.}

\item{legend}{Logical; if \code{TRUE}, the plots contain legends.}

\item{xlim}{Vector with x limits (timeline) for each plot if supplied;
default is c(0, x$cpmax).}

\item{ylim}{Vector with y limits for plots of type "events" and "hazard". For
changing ylim for only one of them, plot them separately by use of argument
'type'.}

\item{main}{Main title for each plot if supplied.}

\item{xlab}{Character vector used as x label for all plots if supplied.}

\item{ylab}{Character vector used as y label for all plots if supplied.}

\item{min.time}{Left bound of time domain used for
\code{\link[muhaz]{muhaz}}. If missing, min.time is considered 0.}

\item{max.time}{Right bound of time domain used for
\code{\link[muhaz]{muhaz}}. If missing, value 'cpmax' of object x is used.}

\item{n.est.grid}{Number of points in the estimation grid, where hazard
estimates are computed (used for \code{\link[muhaz]{muhaz}}). Default value
is 101.}

\item{ask}{If \code{TRUE}, the user is asked for input, before a new figure
is drawn.}

\item{...}{Additional arguments passed through to plotting functions.}
}
\description{
Plot method for objects of class 'cpsurv' inheriting from a call to
\code{\link{cpsurv}}.
}
\details{
The value \code{type = "pvals"} produces a plot with p-values used
  to estimate the stump regression model with superimposed least squares
  regression line. For \code{type = "events"} a barplot is produced with
  frequency of events per unit at risk for each interval (with length
  \code{intwd}. For \code{type = "hazard"} the estimated hazard rate (based
  on \code{\link[muhaz]{muhaz}}) is plotted with optional (normal- or
  percentile-) confidence intervals and the estimated constant hazard rate.
}
\examples{
data(survdata)
cp <- cpsurv(survdata$time, survdata$event, cpmax = 360, intwd = 10)
plot(cp, ask = FALSE)

\dontrun{
cp <- cpsurv(survdata$time, survdata$event, cpmax = 360, intwd = 10,
boot.ci = TRUE)
plot(cp, type = "pvals", ask = FALSE)
}
}
\seealso{
\code{\link[muhaz]{muhaz}}
}
