% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{immigrationdata}
\alias{immigrationdata}
\title{Immigration Choice Conjoint Experiment Data from Hainmueller et. al. (2014).}
\format{
A data frame with 1000 rows and 23 variables:
\describe{
\item{FeatEd}{Education of left candidate containing levels: "College Degree", "Graduate Degree", "Eighth Grade", "Fourth Grade", "High School", "Two Years of College", and "No Education"}
\item{FeatGender}{Gender of left candidate containing levels: "Female" and "Male"}
\item{FeatCountry}{Country of origin of left candidate containing levels: "Poland", "France", "Iraq", "Somalia", "Sudan", "China", "Mexico", "Germany", "Philippines", and "India"}
\item{FeatReason}{Reason for immigration of left candidate containing levels: "Escape political/religious persecution", "Reunite with family members", and "Seek better job"}
\item{FeatJob}{Occupation of left candidate containing levels: "Waiter", "Child care provider", "Teacher", "Nurse", "Construction worker", "Janitor", "Gardener", "Financial analyst", "Computer programmer", "Research scientist", and "Doctor"}
\item{FeatExp}{Job Experience of left candidate containing levels: "More than five years", "No job training", "One-two years", and "Three-five years"}
\item{FeatPlans}{Job Plans of left candidate containing levels: "Does not contract with U.S. employer but have job interview", "No Contract", "No plans", and "Will look for work after arriving"}
\item{FeatTrips}{Trips to U.S. of left candidate containing levels: "Entered U.S. once without legal authorization", "Entered U.S. once before on tourist visa", "Multiple visits on tourist visa", "Never visited", and "Spent six months with family in U.S."}
\item{FeatLang}{Language of left candidate containing levels: "Used interpreter", "Broken English", "Unable to speak English", and "Fluent English"}
\item{FeatEd_2}{Education of right candidate containing levels: "College Degree", "Graduate Degree", "Eighth Grade", "Fourth Grade", "High School", "Two Years of College", and "No Education"}
\item{FeatGender_2}{Gender of right candidate containing levels: "Female" and "Male"}
\item{FeatCountry_2}{Country of origin of right candidate containing levels: "Poland", "France", "Iraq", "Somalia", "Sudan", "China", "Mexico", "Germany", "Philippines", and "India"}
\item{FeatReason_2}{Reason for immigration of right candidate containing levels: "Escape political/religious persecution", "Reunite with family members", and "Seek better job"}
\item{FeatJob_2}{Occupation of right candidate containing levels: "Waiter", "Child care provider", "Teacher", "Nurse", "Construction worker", "Janitor", "Gardener", "Financial analyst", "Computer programmer", "Research scientist", and "Doctor"}
\item{FeatExp_2}{Job Experience of right candidate containing levels: "More than five years", "No job training", "One-two years", and "Three-five years"}
\item{FeatPlans_2}{Job Plans of right candidate containing levels: "Does not contract with U.S. employer but have job interview", "No Contract", "No plans", and "Will look for work after arriving"}
\item{FeatTrips_2}{Trips to U.S. of right candidate containing levels: "Entered U.S. once without legal authorization", "Entered U.S. once before on tourist visa", "Multiple visits on tourist visa", "Never visited", and "Spent six months with family in U.S."}
\item{FeatLang_2}{Language of right candidate containing levels: "Used interpreter", "Broken English", "Unable to speak English", and "Fluent English"}
\item{ppage}{Respondent age (numeric variable)}
\item{ppeducat}{Respondent education containing levels}
\item{ppethm}{Respondent ethnicity}
\item{ppgender}{Respondent gender}
\item{Y}{Binary response variable Y: 1 if left profile is selected and 0 otherwise}
}
}
\usage{
immigrationdata
}
\description{
This dataset is a subset of the first 1000 rows chosen from the original immigration dataset.
Each row consists of a pair of immigrant candidates that were shown to respondents.
The respondent then chooses either the left or right profile (main binary response) from
the nine profile factors shown for each candidate. Respondent characteristics are also recorded.
For example, the first row shows that the left immigrant candidate was a Male from Iraq
who had a high school degree, etc. while the right immigrant candidate was a Female from France
with no formal education, etc. The respondent who evaluated this task was a 20 year old
college educated White Male, who voted for the left immigrant candidate.
}
\keyword{datasets}
